/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.chatgpt.config;

import com.unfbx.chatgpt.OpenAiClient;
import com.unfbx.chatgpt.OpenAiStreamClient;
import com.unfbx.chatgpt.function.KeyRandomStrategy;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import com.unfbx.chatgpt.interceptor.OpenAILogger;
import com.unfbx.chatgpt.interceptor.OpenAiResponseInterceptor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang.StringUtils;
import org.jeecg.chatgpt.prop.AiChatProperties;
import org.jeecg.chatgpt.service.AiChatService;
import org.jeecg.chatgpt.service.impl.ChatGptService;
import org.jeecg.chatgpt.service.impl.DefaultAiChatService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AiChatProperties.class})
public class AiChatAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="jeecg.ai-chat", name={"enabled"}, havingValue="true")
    public OpenAiClient openAiClient(AiChatProperties aiChatProperties) {
        OkHttpClient okHttpClient = AiChatAutoConfiguration.buildHttpClient(aiChatProperties);
        String apiHost = aiChatProperties.getApiHost();
        if (!apiHost.isEmpty() && !apiHost.endsWith("/")) {
            apiHost = apiHost + "/";
        }
        return OpenAiClient.builder().apiKey(Collections.singletonList(aiChatProperties.getApiKey())).keyStrategy((KeyStrategyFunction)new KeyRandomStrategy()).okHttpClient(okHttpClient).apiHost(apiHost).build();
    }

    @Bean
    @ConditionalOnProperty(prefix="jeecg.ai-chat", name={"enabled"}, havingValue="true")
    public OpenAiStreamClient openAiStreamClient(AiChatProperties aiChatProperties) {
        OkHttpClient okHttpClient = AiChatAutoConfiguration.buildHttpClient(aiChatProperties);
        String apiHost = aiChatProperties.getApiHost();
        if (!apiHost.isEmpty() && !apiHost.endsWith("/")) {
            apiHost = apiHost + "/";
        }
        return OpenAiStreamClient.builder().apiKey(Collections.singletonList(aiChatProperties.getApiKey())).keyStrategy((KeyStrategyFunction)new KeyRandomStrategy()).okHttpClient(okHttpClient).apiHost(apiHost).build();
    }

    private static OkHttpClient buildHttpClient(AiChatProperties aiChatProperties) {
        AiChatProperties.Proxy proxyProp = aiChatProperties.getProxy();
        Proxy proxy = null;
        if (null != proxyProp && StringUtils.isNotEmpty((String)proxyProp.getHost())) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyProp.getHost(), (int)proxyProp.getPort()));
        }
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new OpenAILogger());
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().proxy(proxy).addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)new OpenAiResponseInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).writeTimeout((long)aiChatProperties.getTimeout(), TimeUnit.SECONDS).readTimeout((long)aiChatProperties.getTimeout(), TimeUnit.SECONDS).build();
        return okHttpClient;
    }

    @Bean
    @ConditionalOnBean(value={OpenAiClient.class})
    public AiChatService chatGptAiChatService(OpenAiClient openAiClient, AiChatProperties aiChatProperties) {
        return new ChatGptService(openAiClient, aiChatProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={AiChatService.class})
    public AiChatService defaultAiChatService() {
        return new DefaultAiChatService();
    }
}

