/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.async;

import darabonba.core.ResponseBytes;
import darabonba.core.TeaResponseHandler;
import darabonba.core.async.ByteArrayAsyncResponseHandler;
import darabonba.core.async.FileAsyncResponseHandler;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.reactivestreams.Publisher;

public interface AsyncResponseHandler<ResponseT, ResultT>
extends TeaResponseHandler {
    public void onStream(Publisher<ByteBuffer> var1);

    public void onError(Throwable var1);

    public ResultT transform(ResponseT var1);

    public static <ResponseT> AsyncResponseHandler<ResponseT, ResponseT> toFile(Path path) {
        return new FileAsyncResponseHandler(path);
    }

    public static <ResponseT> AsyncResponseHandler<ResponseT, ResponseT> toFile(File file) {
        return AsyncResponseHandler.toFile(file.toPath());
    }

    public static <ResponseT> AsyncResponseHandler<ResponseT, ResponseBytes<ResponseT>> toBytes() {
        return new ByteArrayAsyncResponseHandler();
    }
}

