/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SetWaitingRoomConfigRequest
extends Request {
    @Query
    @NameInMap(value="AllowPct")
    @Validation(required=true)
    private Integer allowPct;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="GapTime")
    @Validation(required=true)
    private Integer gapTime;
    @Query
    @NameInMap(value="MaxTimeWait")
    @Validation(required=true)
    private Integer maxTimeWait;
    @Query
    @NameInMap(value="WaitUri")
    @Validation(required=true)
    private String waitUri;
    @Query
    @NameInMap(value="WaitUrl")
    @Validation(required=true)
    private String waitUrl;

    private SetWaitingRoomConfigRequest(Builder builder) {
        super((Request.Builder)builder);
        this.allowPct = builder.allowPct;
        this.domainName = builder.domainName;
        this.gapTime = builder.gapTime;
        this.maxTimeWait = builder.maxTimeWait;
        this.waitUri = builder.waitUri;
        this.waitUrl = builder.waitUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetWaitingRoomConfigRequest create() {
        return SetWaitingRoomConfigRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getAllowPct() {
        return this.allowPct;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Integer getGapTime() {
        return this.gapTime;
    }

    public Integer getMaxTimeWait() {
        return this.maxTimeWait;
    }

    public String getWaitUri() {
        return this.waitUri;
    }

    public String getWaitUrl() {
        return this.waitUrl;
    }

    public static final class Builder
    extends Request.Builder<SetWaitingRoomConfigRequest, Builder> {
        private Integer allowPct;
        private String domainName;
        private Integer gapTime;
        private Integer maxTimeWait;
        private String waitUri;
        private String waitUrl;

        private Builder() {
        }

        private Builder(SetWaitingRoomConfigRequest request) {
            super((Request)request);
            this.allowPct = request.allowPct;
            this.domainName = request.domainName;
            this.gapTime = request.gapTime;
            this.maxTimeWait = request.maxTimeWait;
            this.waitUri = request.waitUri;
            this.waitUrl = request.waitUrl;
        }

        public Builder allowPct(Integer allowPct) {
            this.putQueryParameter("AllowPct", allowPct);
            this.allowPct = allowPct;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder gapTime(Integer gapTime) {
            this.putQueryParameter("GapTime", gapTime);
            this.gapTime = gapTime;
            return this;
        }

        public Builder maxTimeWait(Integer maxTimeWait) {
            this.putQueryParameter("MaxTimeWait", maxTimeWait);
            this.maxTimeWait = maxTimeWait;
            return this;
        }

        public Builder waitUri(String waitUri) {
            this.putQueryParameter("WaitUri", waitUri);
            this.waitUri = waitUri;
            return this;
        }

        public Builder waitUrl(String waitUrl) {
            this.putQueryParameter("WaitUrl", waitUrl);
            this.waitUrl = waitUrl;
            return this;
        }

        public SetWaitingRoomConfigRequest build() {
            return new SetWaitingRoomConfigRequest(this);
        }
    }
}

