/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class RefreshObjectCacheByCacheTagRequest
extends Request {
    @Query
    @NameInMap(value="CacheTag")
    @Validation(required=true, maxLength=16384)
    private String cacheTag;
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="Force")
    private Boolean force;

    private RefreshObjectCacheByCacheTagRequest(Builder builder) {
        super((Request.Builder)builder);
        this.cacheTag = builder.cacheTag;
        this.domainName = builder.domainName;
        this.force = builder.force;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RefreshObjectCacheByCacheTagRequest create() {
        return RefreshObjectCacheByCacheTagRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCacheTag() {
        return this.cacheTag;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Boolean getForce() {
        return this.force;
    }

    public static final class Builder
    extends Request.Builder<RefreshObjectCacheByCacheTagRequest, Builder> {
        private String cacheTag;
        private String domainName;
        private Boolean force;

        private Builder() {
        }

        private Builder(RefreshObjectCacheByCacheTagRequest request) {
            super((Request)request);
            this.cacheTag = request.cacheTag;
            this.domainName = request.domainName;
            this.force = request.force;
        }

        public Builder cacheTag(String cacheTag) {
            this.putQueryParameter("CacheTag", cacheTag);
            this.cacheTag = cacheTag;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder force(Boolean force) {
            this.putQueryParameter("Force", force);
            this.force = force;
            return this;
        }

        public RefreshObjectCacheByCacheTagRequest build() {
            return new RefreshObjectCacheByCacheTagRequest(this);
        }
    }
}

