/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class PushObjectCacheRequest
extends Request {
    @Query
    @NameInMap(value="Area")
    private String area;
    @Query
    @NameInMap(value="ConsistencyHash")
    private Boolean consistencyHash;
    @Query
    @NameInMap(value="L2Preload")
    private Boolean l2Preload;
    @Query
    @NameInMap(value="ObjectPath")
    @Validation(required=true)
    private String objectPath;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="QueryHashkey")
    private Boolean queryHashkey;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;
    @Query
    @NameInMap(value="WithHeader")
    private String withHeader;

    private PushObjectCacheRequest(Builder builder) {
        super((Request.Builder)builder);
        this.area = builder.area;
        this.consistencyHash = builder.consistencyHash;
        this.l2Preload = builder.l2Preload;
        this.objectPath = builder.objectPath;
        this.ownerId = builder.ownerId;
        this.queryHashkey = builder.queryHashkey;
        this.securityToken = builder.securityToken;
        this.withHeader = builder.withHeader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PushObjectCacheRequest create() {
        return PushObjectCacheRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getArea() {
        return this.area;
    }

    public Boolean getConsistencyHash() {
        return this.consistencyHash;
    }

    public Boolean getL2Preload() {
        return this.l2Preload;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Boolean getQueryHashkey() {
        return this.queryHashkey;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getWithHeader() {
        return this.withHeader;
    }

    public static final class Builder
    extends Request.Builder<PushObjectCacheRequest, Builder> {
        private String area;
        private Boolean consistencyHash;
        private Boolean l2Preload;
        private String objectPath;
        private Long ownerId;
        private Boolean queryHashkey;
        private String securityToken;
        private String withHeader;

        private Builder() {
        }

        private Builder(PushObjectCacheRequest request) {
            super((Request)request);
            this.area = request.area;
            this.consistencyHash = request.consistencyHash;
            this.l2Preload = request.l2Preload;
            this.objectPath = request.objectPath;
            this.ownerId = request.ownerId;
            this.queryHashkey = request.queryHashkey;
            this.securityToken = request.securityToken;
            this.withHeader = request.withHeader;
        }

        public Builder area(String area) {
            this.putQueryParameter("Area", area);
            this.area = area;
            return this;
        }

        public Builder consistencyHash(Boolean consistencyHash) {
            this.putQueryParameter("ConsistencyHash", consistencyHash);
            this.consistencyHash = consistencyHash;
            return this;
        }

        public Builder l2Preload(Boolean l2Preload) {
            this.putQueryParameter("L2Preload", l2Preload);
            this.l2Preload = l2Preload;
            return this;
        }

        public Builder objectPath(String objectPath) {
            this.putQueryParameter("ObjectPath", objectPath);
            this.objectPath = objectPath;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder queryHashkey(Boolean queryHashkey) {
            this.putQueryParameter("QueryHashkey", queryHashkey);
            this.queryHashkey = queryHashkey;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public Builder withHeader(String withHeader) {
            this.putQueryParameter("WithHeader", withHeader);
            this.withHeader = withHeader;
            return this;
        }

        public PushObjectCacheRequest build() {
            return new PushObjectCacheRequest(this);
        }
    }
}

