/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class OpenCdnServiceRequest
extends Request {
    @Query
    @NameInMap(value="InternetChargeType")
    @Validation(required=true)
    private String internetChargeType;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;

    private OpenCdnServiceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.internetChargeType = builder.internetChargeType;
        this.ownerId = builder.ownerId;
        this.securityToken = builder.securityToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OpenCdnServiceRequest create() {
        return OpenCdnServiceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getInternetChargeType() {
        return this.internetChargeType;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public static final class Builder
    extends Request.Builder<OpenCdnServiceRequest, Builder> {
        private String internetChargeType;
        private Long ownerId;
        private String securityToken;

        private Builder() {
        }

        private Builder(OpenCdnServiceRequest request) {
            super((Request)request);
            this.internetChargeType = request.internetChargeType;
            this.ownerId = request.ownerId;
            this.securityToken = request.securityToken;
        }

        public Builder internetChargeType(String internetChargeType) {
            this.putQueryParameter("InternetChargeType", internetChargeType);
            this.internetChargeType = internetChargeType;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public OpenCdnServiceRequest build() {
            return new OpenCdnServiceRequest(this);
        }
    }
}

