/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ModifyCdnDomainRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;
    @Query
    @NameInMap(value="Sources")
    private String sources;
    @Query
    @NameInMap(value="TopLevelDomain")
    private String topLevelDomain;

    private ModifyCdnDomainRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.ownerId = builder.ownerId;
        this.resourceGroupId = builder.resourceGroupId;
        this.securityToken = builder.securityToken;
        this.sources = builder.sources;
        this.topLevelDomain = builder.topLevelDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyCdnDomainRequest create() {
        return ModifyCdnDomainRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getSources() {
        return this.sources;
    }

    public String getTopLevelDomain() {
        return this.topLevelDomain;
    }

    public static final class Builder
    extends Request.Builder<ModifyCdnDomainRequest, Builder> {
        private String domainName;
        private Long ownerId;
        private String resourceGroupId;
        private String securityToken;
        private String sources;
        private String topLevelDomain;

        private Builder() {
        }

        private Builder(ModifyCdnDomainRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.ownerId = request.ownerId;
            this.resourceGroupId = request.resourceGroupId;
            this.securityToken = request.securityToken;
            this.sources = request.sources;
            this.topLevelDomain = request.topLevelDomain;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public Builder sources(String sources) {
            this.putQueryParameter("Sources", sources);
            this.sources = sources;
            return this;
        }

        public Builder topLevelDomain(String topLevelDomain) {
            this.putQueryParameter("TopLevelDomain", topLevelDomain);
            this.topLevelDomain = topLevelDomain;
            return this;
        }

        public ModifyCdnDomainRequest build() {
            return new ModifyCdnDomainRequest(this);
        }
    }
}

