/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ListTagResourcesRequest
extends Request {
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="ResourceId")
    private List<String> resourceId;
    @Query
    @NameInMap(value="ResourceType")
    @Validation(required=true)
    private String resourceType;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;
    @Query
    @NameInMap(value="TagOwnerBid")
    private String tagOwnerBid;
    @Query
    @NameInMap(value="TagOwnerUid")
    private String tagOwnerUid;

    private ListTagResourcesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.nextToken = builder.nextToken;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.tag = builder.tag;
        this.tagOwnerBid = builder.tagOwnerBid;
        this.tagOwnerUid = builder.tagOwnerUid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListTagResourcesRequest create() {
        return ListTagResourcesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public List<String> getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public String getTagOwnerBid() {
        return this.tagOwnerBid;
    }

    public String getTagOwnerUid() {
        return this.tagOwnerUid;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            private Builder() {
            }

            private Builder(Tag model) {
                this.key = model.key;
                this.value = model.value;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ListTagResourcesRequest, Builder> {
        private String nextToken;
        private List<String> resourceId;
        private String resourceType;
        private List<Tag> tag;
        private String tagOwnerBid;
        private String tagOwnerUid;

        private Builder() {
        }

        private Builder(ListTagResourcesRequest request) {
            super((Request)request);
            this.nextToken = request.nextToken;
            this.resourceId = request.resourceId;
            this.resourceType = request.resourceType;
            this.tag = request.tag;
            this.tagOwnerBid = request.tagOwnerBid;
            this.tagOwnerUid = request.tagOwnerUid;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder resourceId(List<String> resourceId) {
            this.putQueryParameter("ResourceId", resourceId);
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public Builder tagOwnerBid(String tagOwnerBid) {
            this.putQueryParameter("TagOwnerBid", tagOwnerBid);
            this.tagOwnerBid = tagOwnerBid;
            return this;
        }

        public Builder tagOwnerUid(String tagOwnerUid) {
            this.putQueryParameter("TagOwnerUid", tagOwnerUid);
            this.tagOwnerUid = tagOwnerUid;
            return this;
        }

        public ListTagResourcesRequest build() {
            return new ListTagResourcesRequest(this);
        }
    }
}

