/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class DescribeUserDomainsRequest
extends Request {
    @Query
    @NameInMap(value="CdnType")
    private String cdnType;
    @Query
    @NameInMap(value="ChangeEndTime")
    private String changeEndTime;
    @Query
    @NameInMap(value="ChangeStartTime")
    private String changeStartTime;
    @Query
    @NameInMap(value="CheckDomainShow")
    private Boolean checkDomainShow;
    @Query
    @NameInMap(value="Coverage")
    private String coverage;
    @Query
    @NameInMap(value="DomainName")
    @Validation(maxLength=6800)
    private String domainName;
    @Query
    @NameInMap(value="DomainSearchType")
    private String domainSearchType;
    @Query
    @NameInMap(value="DomainStatus")
    private String domainStatus;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=500.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;
    @Query
    @NameInMap(value="SecurityToken")
    private String securityToken;
    @Query
    @NameInMap(value="Source")
    private String source;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;

    private DescribeUserDomainsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.cdnType = builder.cdnType;
        this.changeEndTime = builder.changeEndTime;
        this.changeStartTime = builder.changeStartTime;
        this.checkDomainShow = builder.checkDomainShow;
        this.coverage = builder.coverage;
        this.domainName = builder.domainName;
        this.domainSearchType = builder.domainSearchType;
        this.domainStatus = builder.domainStatus;
        this.ownerId = builder.ownerId;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.resourceGroupId = builder.resourceGroupId;
        this.securityToken = builder.securityToken;
        this.source = builder.source;
        this.tag = builder.tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeUserDomainsRequest create() {
        return DescribeUserDomainsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCdnType() {
        return this.cdnType;
    }

    public String getChangeEndTime() {
        return this.changeEndTime;
    }

    public String getChangeStartTime() {
        return this.changeStartTime;
    }

    public Boolean getCheckDomainShow() {
        return this.checkDomainShow;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDomainSearchType() {
        return this.domainSearchType;
    }

    public String getDomainStatus() {
        return this.domainStatus;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getSource() {
        return this.source;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            private Builder() {
            }

            private Builder(Tag model) {
                this.key = model.key;
                this.value = model.value;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<DescribeUserDomainsRequest, Builder> {
        private String cdnType;
        private String changeEndTime;
        private String changeStartTime;
        private Boolean checkDomainShow;
        private String coverage;
        private String domainName;
        private String domainSearchType;
        private String domainStatus;
        private Long ownerId;
        private Integer pageNumber;
        private Integer pageSize;
        private String resourceGroupId;
        private String securityToken;
        private String source;
        private List<Tag> tag;

        private Builder() {
        }

        private Builder(DescribeUserDomainsRequest request) {
            super((Request)request);
            this.cdnType = request.cdnType;
            this.changeEndTime = request.changeEndTime;
            this.changeStartTime = request.changeStartTime;
            this.checkDomainShow = request.checkDomainShow;
            this.coverage = request.coverage;
            this.domainName = request.domainName;
            this.domainSearchType = request.domainSearchType;
            this.domainStatus = request.domainStatus;
            this.ownerId = request.ownerId;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.resourceGroupId = request.resourceGroupId;
            this.securityToken = request.securityToken;
            this.source = request.source;
            this.tag = request.tag;
        }

        public Builder cdnType(String cdnType) {
            this.putQueryParameter("CdnType", cdnType);
            this.cdnType = cdnType;
            return this;
        }

        public Builder changeEndTime(String changeEndTime) {
            this.putQueryParameter("ChangeEndTime", changeEndTime);
            this.changeEndTime = changeEndTime;
            return this;
        }

        public Builder changeStartTime(String changeStartTime) {
            this.putQueryParameter("ChangeStartTime", changeStartTime);
            this.changeStartTime = changeStartTime;
            return this;
        }

        public Builder checkDomainShow(Boolean checkDomainShow) {
            this.putQueryParameter("CheckDomainShow", checkDomainShow);
            this.checkDomainShow = checkDomainShow;
            return this;
        }

        public Builder coverage(String coverage) {
            this.putQueryParameter("Coverage", coverage);
            this.coverage = coverage;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder domainSearchType(String domainSearchType) {
            this.putQueryParameter("DomainSearchType", domainSearchType);
            this.domainSearchType = domainSearchType;
            return this;
        }

        public Builder domainStatus(String domainStatus) {
            this.putQueryParameter("DomainStatus", domainStatus);
            this.domainStatus = domainStatus;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.putQueryParameter("SecurityToken", securityToken);
            this.securityToken = securityToken;
            return this;
        }

        public Builder source(String source) {
            this.putQueryParameter("Source", source);
            this.source = source;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public DescribeUserDomainsRequest build() {
            return new DescribeUserDomainsRequest(this);
        }
    }
}

