/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeTopDomainsByFlowRequest
extends Request {
    @Query
    @NameInMap(value="EndTime")
    private String endTime;
    @Query
    @NameInMap(value="Limit")
    @Validation(maximum=100.0, minimum=1.0)
    private Long limit;
    @Query
    @NameInMap(value="StartTime")
    private String startTime;

    private DescribeTopDomainsByFlowRequest(Builder builder) {
        super((Request.Builder)builder);
        this.endTime = builder.endTime;
        this.limit = builder.limit;
        this.startTime = builder.startTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeTopDomainsByFlowRequest create() {
        return DescribeTopDomainsByFlowRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public static final class Builder
    extends Request.Builder<DescribeTopDomainsByFlowRequest, Builder> {
        private String endTime;
        private Long limit;
        private String startTime;

        private Builder() {
        }

        private Builder(DescribeTopDomainsByFlowRequest request) {
            super((Request)request);
            this.endTime = request.endTime;
            this.limit = request.limit;
            this.startTime = request.startTime;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder limit(Long limit) {
            this.putQueryParameter("Limit", limit);
            this.limit = limit;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public DescribeTopDomainsByFlowRequest build() {
            return new DescribeTopDomainsByFlowRequest(this);
        }
    }
}

