/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeDomainVerifyDataRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="GlobalResourcePlan")
    private String globalResourcePlan;

    private DescribeDomainVerifyDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.globalResourcePlan = builder.globalResourcePlan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDomainVerifyDataRequest create() {
        return DescribeDomainVerifyDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getGlobalResourcePlan() {
        return this.globalResourcePlan;
    }

    public static final class Builder
    extends Request.Builder<DescribeDomainVerifyDataRequest, Builder> {
        private String domainName;
        private String globalResourcePlan;

        private Builder() {
        }

        private Builder(DescribeDomainVerifyDataRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.globalResourcePlan = request.globalResourcePlan;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder globalResourcePlan(String globalResourcePlan) {
            this.putQueryParameter("GlobalResourcePlan", globalResourcePlan);
            this.globalResourcePlan = globalResourcePlan;
            return this;
        }

        public DescribeDomainVerifyDataRequest build() {
            return new DescribeDomainVerifyDataRequest(this);
        }
    }
}

