/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeDomainUsageDataRequest
extends Request {
    @Query
    @NameInMap(value="Area")
    private String area;
    @Query
    @NameInMap(value="DataProtocol")
    private String dataProtocol;
    @Query
    @NameInMap(value="DomainName")
    private String domainName;
    @Query
    @NameInMap(value="EndTime")
    @Validation(required=true)
    private String endTime;
    @Query
    @NameInMap(value="Field")
    @Validation(required=true)
    private String field;
    @Query
    @NameInMap(value="Interval")
    private String interval;
    @Query
    @NameInMap(value="ServiceType")
    private String serviceType;
    @Query
    @NameInMap(value="StartTime")
    @Validation(required=true)
    private String startTime;
    @Query
    @NameInMap(value="Type")
    private String type;

    private DescribeDomainUsageDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.area = builder.area;
        this.dataProtocol = builder.dataProtocol;
        this.domainName = builder.domainName;
        this.endTime = builder.endTime;
        this.field = builder.field;
        this.interval = builder.interval;
        this.serviceType = builder.serviceType;
        this.startTime = builder.startTime;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDomainUsageDataRequest create() {
        return DescribeDomainUsageDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getArea() {
        return this.area;
    }

    public String getDataProtocol() {
        return this.dataProtocol;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getField() {
        return this.field;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getType() {
        return this.type;
    }

    public static final class Builder
    extends Request.Builder<DescribeDomainUsageDataRequest, Builder> {
        private String area;
        private String dataProtocol;
        private String domainName;
        private String endTime;
        private String field;
        private String interval;
        private String serviceType;
        private String startTime;
        private String type;

        private Builder() {
        }

        private Builder(DescribeDomainUsageDataRequest request) {
            super((Request)request);
            this.area = request.area;
            this.dataProtocol = request.dataProtocol;
            this.domainName = request.domainName;
            this.endTime = request.endTime;
            this.field = request.field;
            this.interval = request.interval;
            this.serviceType = request.serviceType;
            this.startTime = request.startTime;
            this.type = request.type;
        }

        public Builder area(String area) {
            this.putQueryParameter("Area", area);
            this.area = area;
            return this;
        }

        public Builder dataProtocol(String dataProtocol) {
            this.putQueryParameter("DataProtocol", dataProtocol);
            this.dataProtocol = dataProtocol;
            return this;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder field(String field) {
            this.putQueryParameter("Field", field);
            this.field = field;
            return this;
        }

        public Builder interval(String interval) {
            this.putQueryParameter("Interval", interval);
            this.interval = interval;
            return this;
        }

        public Builder serviceType(String serviceType) {
            this.putQueryParameter("ServiceType", serviceType);
            this.serviceType = serviceType;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder type(String type) {
            this.putQueryParameter("Type", type);
            this.type = type;
            return this;
        }

        public DescribeDomainUsageDataRequest build() {
            return new DescribeDomainUsageDataRequest(this);
        }
    }
}

