/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeDomainPathDataRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    @Validation(required=true)
    private String domainName;
    @Query
    @NameInMap(value="EndTime")
    private String endTime;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=1000.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="Path")
    private String path;
    @Query
    @NameInMap(value="StartTime")
    private String startTime;

    private DescribeDomainPathDataRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.endTime = builder.endTime;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.path = builder.path;
        this.startTime = builder.startTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeDomainPathDataRequest create() {
        return DescribeDomainPathDataRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getPath() {
        return this.path;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public static final class Builder
    extends Request.Builder<DescribeDomainPathDataRequest, Builder> {
        private String domainName;
        private String endTime;
        private Integer pageNumber;
        private Integer pageSize;
        private String path;
        private String startTime;

        private Builder() {
        }

        private Builder(DescribeDomainPathDataRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.endTime = request.endTime;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.path = request.path;
            this.startTime = request.startTime;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder path(String path) {
            this.putQueryParameter("Path", path);
            this.path = path;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public DescribeDomainPathDataRequest build() {
            return new DescribeDomainPathDataRequest(this);
        }
    }
}

