/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeCustomDomainSampleRateRequest
extends Request {
    @Query
    @NameInMap(value="DomainNames")
    private String domainNames;
    @Query
    @NameInMap(value="PageNumber")
    private Long pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;

    private DescribeCustomDomainSampleRateRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainNames = builder.domainNames;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeCustomDomainSampleRateRequest create() {
        return DescribeCustomDomainSampleRateRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainNames() {
        return this.domainNames;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<DescribeCustomDomainSampleRateRequest, Builder> {
        private String domainNames;
        private Long pageNumber;
        private Long pageSize;

        private Builder() {
        }

        private Builder(DescribeCustomDomainSampleRateRequest request) {
            super((Request)request);
            this.domainNames = request.domainNames;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder domainNames(String domainNames) {
            this.putQueryParameter("DomainNames", domainNames);
            this.domainNames = domainNames;
            return this;
        }

        public Builder pageNumber(Long pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public DescribeCustomDomainSampleRateRequest build() {
            return new DescribeCustomDomainSampleRateRequest(this);
        }
    }
}

