/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeCdnWafDomainRequest
extends Request {
    @Query
    @NameInMap(value="DomainName")
    private String domainName;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceGroupId")
    private String resourceGroupId;

    private DescribeCdnWafDomainRequest(Builder builder) {
        super((Request.Builder)builder);
        this.domainName = builder.domainName;
        this.regionId = builder.regionId;
        this.resourceGroupId = builder.resourceGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeCdnWafDomainRequest create() {
        return DescribeCdnWafDomainRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public static final class Builder
    extends Request.Builder<DescribeCdnWafDomainRequest, Builder> {
        private String domainName;
        private String regionId;
        private String resourceGroupId;

        private Builder() {
        }

        private Builder(DescribeCdnWafDomainRequest request) {
            super((Request)request);
            this.domainName = request.domainName;
            this.regionId = request.regionId;
            this.resourceGroupId = request.resourceGroupId;
        }

        public Builder domainName(String domainName) {
            this.putQueryParameter("DomainName", domainName);
            this.domainName = domainName;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.putQueryParameter("ResourceGroupId", resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public DescribeCdnWafDomainRequest build() {
            return new DescribeCdnWafDomainRequest(this);
        }
    }
}

