/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cdn20180510.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateCdnCertificateSigningRequestRequest
extends Request {
    @Query
    @NameInMap(value="City")
    private String city;
    @Query
    @NameInMap(value="CommonName")
    @Validation(required=true)
    private String commonName;
    @Query
    @NameInMap(value="Country")
    private String country;
    @Query
    @NameInMap(value="Email")
    private String email;
    @Query
    @NameInMap(value="Organization")
    private String organization;
    @Query
    @NameInMap(value="OrganizationUnit")
    private String organizationUnit;
    @Query
    @NameInMap(value="SANs")
    private String SANs;
    @Query
    @NameInMap(value="State")
    private String state;

    private CreateCdnCertificateSigningRequestRequest(Builder builder) {
        super((Request.Builder)builder);
        this.city = builder.city;
        this.commonName = builder.commonName;
        this.country = builder.country;
        this.email = builder.email;
        this.organization = builder.organization;
        this.organizationUnit = builder.organizationUnit;
        this.SANs = builder.SANs;
        this.state = builder.state;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateCdnCertificateSigningRequestRequest create() {
        return CreateCdnCertificateSigningRequestRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCity() {
        return this.city;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getCountry() {
        return this.country;
    }

    public String getEmail() {
        return this.email;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public String getSANs() {
        return this.SANs;
    }

    public String getState() {
        return this.state;
    }

    public static final class Builder
    extends Request.Builder<CreateCdnCertificateSigningRequestRequest, Builder> {
        private String city;
        private String commonName;
        private String country;
        private String email;
        private String organization;
        private String organizationUnit;
        private String SANs;
        private String state;

        private Builder() {
        }

        private Builder(CreateCdnCertificateSigningRequestRequest request) {
            super((Request)request);
            this.city = request.city;
            this.commonName = request.commonName;
            this.country = request.country;
            this.email = request.email;
            this.organization = request.organization;
            this.organizationUnit = request.organizationUnit;
            this.SANs = request.SANs;
            this.state = request.state;
        }

        public Builder city(String city) {
            this.putQueryParameter("City", city);
            this.city = city;
            return this;
        }

        public Builder commonName(String commonName) {
            this.putQueryParameter("CommonName", commonName);
            this.commonName = commonName;
            return this;
        }

        public Builder country(String country) {
            this.putQueryParameter("Country", country);
            this.country = country;
            return this;
        }

        public Builder email(String email) {
            this.putQueryParameter("Email", email);
            this.email = email;
            return this;
        }

        public Builder organization(String organization) {
            this.putQueryParameter("Organization", organization);
            this.organization = organization;
            return this;
        }

        public Builder organizationUnit(String organizationUnit) {
            this.putQueryParameter("OrganizationUnit", organizationUnit);
            this.organizationUnit = organizationUnit;
            return this;
        }

        public Builder SANs(String SANs) {
            this.putQueryParameter("SANs", SANs);
            this.SANs = SANs;
            return this;
        }

        public Builder state(String state) {
            this.putQueryParameter("State", state);
            this.state = state;
            return this;
        }

        public CreateCdnCertificateSigningRequestRequest build() {
            return new CreateCdnCertificateSigningRequestRequest(this);
        }
    }
}

